/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.animation;

import filenet.sim.animationdp.IVWSIMAnimation;
import filenet.sim.animationdp.IVWSIMAnimationCommand;
import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.IVWSIMAnimationInfo;
import filenet.sim.animationdp.IVWSIMEvent;
import filenet.sim.animationdp.IVWSIMMapStats;
import filenet.sim.animationdp.IVWSIMQueueStats;
import filenet.sim.animationdp.IVWSIMStatistics;
import filenet.sim.animationdp.IVWSIMStepStats;
import filenet.sim.animationdp.IVWSIMUserStats;
import filenet.sim.animationdp.IVWSIMWorkClassStats;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorQueue;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.VWSIMAnimatorUser;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.animation.IVWSIMAnimationUpdateListener;
import filenet.sim.toolkit.viewer.animation.IVWSIMAnimationUpdateNotifier;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationUpdateEvent;
import filenet.sim.toolkit.viewer.mapui.IVWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorRouteUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowMapPane;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowPane;
import filenet.sim.toolkit.viewer.resources.VWSIMResource;
import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWDuration;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import java.awt.Frame;
import java.util.Date;
import java.util.Vector;

public class VWSIMAnimationController
implements IVWSIMAnimationUpdateNotifier {
    public static final int ANIMATION_THREAD_COUNT = 1;
    public static final int ANIMATION_STOP = 0;
    public static final int ANIMATION_PAUSE = 1;
    public static final int ANIMATION_PLAY = 2;
    public static final int EVENT_STATUS_NORMAL = 0;
    public static final int EVENT_STATUS_TIMEOUT = 1;
    public static final int EVENT_STATUS_ERROR = 2;
    public static final int EVENT_STATUS_SIM_ERROR = 3;
    public int m_playMode = 0;
    private Object m_semaphore = new Object();
    private boolean m_bInitialized = false;
    private boolean m_bDone = false;
    private IVWSIMSimulation m_simulation = null;
    private IVWSIMAnimationDP m_animationDP = null;
    private VWSIMAnimatorDataModel m_dataModel = null;
    private VWSIMAnimatorWorkflowPane m_workflowPane = null;
    private Vector m_workflowMaps = null;
    private Object m_finishedObject = new Object();
    private boolean m_bFinished = false;
    private boolean m_bTimeout = false;
    private int m_eventCount = 0;
    private IVWSIMEvent m_lastEvent = null;
    private Date m_lastEventTime = null;
    private Date m_lastPlayedEventTime = null;
    private Object m_lastEventSemaphore = new Object();
    private long m_delayInMilliSeconds = 20L;
    private int m_eventsToSkip = 5;
    private int m_skipEventCount = 0;
    private boolean m_bPlayEvent = true;
    private boolean m_bPlayAnimation = true;
    private boolean m_bUpdateStats = true;
    private long m_lastStatUpdateTime = 0L;
    private boolean m_bGetEventError = false;
    private int m_eventStatus = 0;
    private int m_playbackRate = 100;
    private int m_timeRatio = 6000;
    private boolean m_bTimeBased = true;
    private long m_realStartTime = -1L;
    private long m_animationStartTime = -1L;
    private long m_realTimeDuration = -1L;
    private long m_animationTimeDuration = -1L;
    private long m_playbackDuration = -1L;
    private Date m_animationTime = null;
    private Object m_animationTimeUpdateSemaphore = new Object();
    private Date m_simulationBeginTime = null;
    private Date m_simulationEndTime = null;
    private VWDuration m_simulationDuration = null;
    private Vector m_animationUpdateListeners = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date:   14 Feb 2005 14:51:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.23  $";
    }

    public void setSimulation(IVWSIMSimulation simulation) {
        this.m_simulation = simulation;
        try {
            if (this.m_simulation != null) {
                IVWSIMAnimationDP dp = this.m_simulation.getAnimationDataProvider();
                if (dp != null && dp instanceof IVWSIMAnimationDP) {
                    this.m_animationDP = dp;
                }
                this.setPlaybackRate(this.m_playbackRate);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, ex.getLocalizedMessage());
        }
    }

    public void setSimulation(IVWSIMAnimationDP animationdp) {
        this.m_simulation = null;
        this.m_animationDP = animationdp;
    }

    public synchronized void initialize(VWSIMAnimatorDataModel dataModel, VWSIMAnimatorWorkflowPane workflowPane) {
        this.m_dataModel = dataModel;
        this.m_workflowPane = workflowPane;
        if (this.m_workflowPane != null) {
            this.m_workflowMaps = this.m_workflowPane.getWorkflowMaps();
        }
        this.m_bInitialized = true;
    }

    public VWSIMAnimatorDataModel getDataModel() {
        return this.m_dataModel;
    }

    public synchronized boolean isInitialized() {
        return this.m_bInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayMode(int mode) {
        if (!this.m_bInitialized) {
            return;
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            if (this.m_playMode == 2 && mode == 1) {
                Date time = new Date();
                this.m_playbackDuration += time.getTime() - this.m_realStartTime;
            } else if (this.m_playMode == 1 && mode == 2) {
                this.m_realStartTime = -1L;
                this.m_animationStartTime = -1L;
                this.m_realTimeDuration = 0L;
                this.m_animationTimeDuration = 0L;
                if (this.m_eventStatus == 1) {
                    if (this.m_animationDP != null) {
                        this.m_animationDP.continueAfterTimeout();
                    }
                    this.m_eventStatus = 0;
                }
            } else if (this.m_playMode == 0 && mode == 2) {
                VWSIMAnimatorWorkflowMapPane activeMapPane;
                this.setFinished(false);
                this.m_realStartTime = -1L;
                this.m_playbackDuration = 0L;
                this.m_animationStartTime = -1L;
                this.m_realTimeDuration = 0L;
                this.m_animationTimeDuration = 0L;
                this.setAnimationTime(null);
                this.m_bGetEventError = false;
                this.m_eventStatus = 0;
                this.m_eventCount = 0;
                if (this.m_dataModel != null) {
                    this.m_dataModel.clearStatistics();
                }
                if (this.m_animationDP != null) {
                    try {
                        this.m_animationDP.restart();
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex, ex.getLocalizedMessage());
                    }
                }
                if (this.m_workflowPane != null && (activeMapPane = (VWSIMAnimatorWorkflowMapPane)this.m_workflowPane.getActiveMapPane()) != null) {
                    VWSIMAnimatorMap map = activeMapPane.getMapData();
                    if (map != null) {
                        Vector steps = map.getSteps();
                        Object obj = null;
                        if (steps != null && steps.size() > 0) {
                            for (int i = 0; i < steps.size(); ++i) {
                                IVWSIMAnimatorStepUI stepUI;
                                obj = steps.elementAt(i);
                                if (obj == null || !(obj instanceof VWSIMAnimatorStep) || (stepUI = activeMapPane.findStep((VWSIMAnimatorStep)obj)) == null || stepUI.getAnimatorStepUI() == null) continue;
                                stepUI.getAnimatorStepUI().updateActiveItemCount();
                            }
                        }
                    }
                    activeMapPane.invalidateMap();
                }
            }
            this.m_playMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayMode() {
        Object object = this.m_semaphore;
        synchronized (object) {
            return this.m_playMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinished(boolean bFinished) {
        Object object = this.m_finishedObject;
        synchronized (object) {
            this.m_bFinished = bFinished;
            if (this.m_bFinished && this.m_simulationEndTime == null) {
                this.m_simulationEndTime = this.m_animationTime;
            }
        }
        if (bFinished && this.m_realStartTime != -1L) {
            Date time = new Date();
            this.m_playbackDuration += time.getTime() - this.m_realStartTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.m_finishedObject;
        synchronized (object) {
            return this.m_bFinished;
        }
    }

    public boolean isTimeout() {
        if (this.m_animationDP != null) {
            return this.m_animationDP.isTimedOut();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate() {
        int playMode = -1;
        boolean i = false;
        while (!this.m_bDone) {
            Object object = this.m_semaphore;
            synchronized (object) {
                playMode = this.m_playMode;
            }
            this.m_bPlayEvent = false;
            switch (playMode) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    object = this.m_semaphore;
                    synchronized (object) {
                        if (this.m_bFinished) {
                            break;
                        }
                    }
                    this.m_bPlayEvent = false;
                    this.m_bUpdateStats = false;
                    IVWSIMEvent event = this.getNextEvent();
                    if (event != null) {
                        if (event.finished()) {
                            if (!this.isTimeout()) {
                                this.setFinished(true);
                                this.m_bPlayEvent = true;
                                this.m_bUpdateStats = true;
                            }
                        } else if (this.m_realTimeDuration == 0L) {
                            this.m_bPlayEvent = true;
                        } else {
                            long timeDiff = this.m_animationTimeDuration - this.m_realTimeDuration;
                            if (timeDiff >= -50L) {
                                boolean count = false;
                                while (timeDiff > 50L && this.getPlayMode() == 2) {
                                    Thread.yield();
                                    this.m_realTimeDuration = (new Date().getTime() - this.m_realStartTime) * (long)this.m_timeRatio;
                                    timeDiff = this.m_animationTimeDuration - this.m_realTimeDuration;
                                }
                                this.m_bPlayEvent = true;
                            }
                        }
                        if (this.m_bPlayEvent) {
                            this.playAnimationEvent(event);
                        }
                        if (!event.finished()) break;
                        if (this.isTimeout()) {
                            this.notifyAnimationUpdateListener(new VWSIMAnimationUpdateEvent(this, null, this.m_eventStatus));
                            break;
                        }
                        this.notifyAnimationUpdateListener(new VWSIMAnimationUpdateEvent(this, event, this.m_eventStatus));
                        break;
                    }
                    this.notifyAnimationUpdateListener(new VWSIMAnimationUpdateEvent(this, null, this.m_eventStatus));
                    this.m_bGetEventError = false;
                }
            }
            try {
                if (playMode == 2) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVWSIMEvent getNextEvent() {
        if (this.m_bGetEventError) {
            return null;
        }
        if (this.m_animationDP != null) {
            try {
                IVWSIMEvent event = null;
                while (this.m_playMode == 2) {
                    Object msg;
                    event = this.m_animationDP.getEvent();
                    if (!this.isFinished() && event == null) {
                        return null;
                    }
                    if (event != null && event.finished() && this.m_animationDP.isTimedOut()) {
                        this.m_eventStatus = 1;
                        msg = null;
                        msg = event.getStatusMessage() != null ? VWSIMResource.s_timeoutRetrievingAnimationEvent.toString(event.getStatusMessage()) : VWSIMResource.s_timeoutRetrievingAnimationEvent.toString();
                        VWMessageDialog.showOptionDialog(new Frame(), (String)msg, VWSIMResource.s_error, 1);
                        return event;
                    }
                    if (event != null && event.getStatus() == 4) {
                        this.m_bGetEventError = true;
                        this.m_eventStatus = 3;
                        msg = null;
                        msg = event.getStatusMessage() != null ? VWSIMResource.s_simulationError.toString(event.getStatusMessage()) : VWSIMResource.s_simulationError.toString();
                        VWMessageDialog.showOptionDialog(new Frame(), (String)msg, VWSIMResource.s_error, 1);
                        return event;
                    }
                    msg = this.m_lastEventSemaphore;
                    synchronized (msg) {
                        this.m_lastEvent = event;
                        Date lastEventTime = this.m_lastEvent.getTimeStamp();
                        if (lastEventTime != null && lastEventTime.getTime() != -1L) {
                            this.m_lastEventTime = lastEventTime;
                            if (this.m_simulationBeginTime == null) {
                                this.m_simulationBeginTime = lastEventTime;
                            }
                        }
                    }
                    this.updateWorkflowStatistics();
                    ++this.m_eventCount;
                    if (!this.ignoreEvent(event)) {
                        if (event != null && this.m_bTimeBased) {
                            if (this.m_realStartTime == -1L) {
                                this.m_realStartTime = new Date().getTime();
                                Date time = event.getTimeStamp();
                                if (time != null) {
                                    this.m_animationStartTime = time.getTime();
                                }
                                this.m_realTimeDuration = 0L;
                                this.m_animationTimeDuration = 0L;
                            } else {
                                this.m_realTimeDuration = (new Date().getTime() - this.m_realStartTime) * (long)this.m_timeRatio;
                                Date animationTime = event.getTimeStamp();
                                if (animationTime != null) {
                                    if (this.m_animationStartTime == -1L) {
                                        this.m_animationStartTime = animationTime.getTime();
                                    }
                                    this.m_animationTimeDuration = animationTime.getTime() - this.m_animationStartTime;
                                    this.setAnimationTime(animationTime);
                                } else {
                                    this.m_animationTimeDuration = 0L;
                                }
                            }
                        }
                        return event;
                    }
                    if (this.m_eventCount % 100 == 0) {
                        this.m_eventCount = 0;
                        this.m_realStartTime = -1L;
                        this.m_animationStartTime = -1L;
                        this.m_realTimeDuration = 0L;
                        this.m_animationTimeDuration = 0L;
                    }
                    Thread.yield();
                }
            }
            catch (VWException ex) {
                this.m_bGetEventError = true;
                this.m_eventStatus = 2;
                String msg = null;
                msg = ex.getLocalizedMessage() != null ? VWSIMResource.s_failedToRetrieveAnimationEvent.toString(ex.getLocalizedMessage()) : VWSIMResource.s_failedToRetrieveAnimationEvent.toString();
                VWMessageDialog.showOptionDialog(new Frame(), msg, VWSIMResource.s_error, 1);
            }
        }
        return null;
    }

    private void playAnimationEvent(IVWSIMEvent event) {
        if (event == null) {
            return;
        }
        this.m_lastPlayedEventTime = event.getTimeStamp();
        try {
            IVWSIMAnimationInfo[] infos;
            IVWSIMAnimation animation = event.getAnimation();
            if (animation != null && (infos = animation.getAnimationInfo()) != null && infos.length > 0) {
                for (int i = 0; i < infos.length; ++i) {
                    this.playAnimationInfo(infos[i]);
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, ex.getLocalizedMessage());
        }
    }

    private void playAnimationInfo(IVWSIMAnimationInfo info) {
        if (info == null) {
            return;
        }
        if (info != null) {
            int workClassId = info.getWorkClassID();
            IVWSIMAnimationCommand[] commands = info.getCommands();
            if (commands != null && commands.length > 0) {
                for (int i = 0; i < commands.length; ++i) {
                    if (commands[i] == null) continue;
                    this.playAnimationCommand(workClassId, commands[i]);
                }
            }
        }
    }

    private void playAnimationCommand(int workClassId, IVWSIMAnimationCommand animationCommand) {
        if (animationCommand == null) {
            return;
        }
        if (animationCommand != null) {
            int command = animationCommand.getCommand();
            int prevMapId = animationCommand.getPrevMapId();
            int prevStepId = animationCommand.getPrevStepId();
            int nextMapId = animationCommand.getNextMapId();
            int nextStepId = animationCommand.getNextStepId();
            VWSIMAnimatorStep prevStep = this.findStep(workClassId, prevMapId, prevStepId);
            IVWSIMAnimatorStepUI prevStepUI = this.findStepUI(workClassId, prevMapId, prevStepId);
            VWSIMAnimatorStep nextStep = this.findStep(workClassId, nextMapId, nextStepId);
            IVWSIMAnimatorStepUI nextStepUI = this.findStepUI(workClassId, nextMapId, nextStepId);
            VWSIMAnimatorWorkflowMapPane prevMapPane = null;
            VWSIMAnimatorWorkflowMapPane nextMapPane = null;
            if (prevStep != null) {
                prevMapPane = this.m_workflowPane.getMapPane(workClassId, prevStep.getMapId());
            }
            if (nextStep != null) {
                nextMapPane = this.m_workflowPane.getMapPane(workClassId, nextStep.getMapId());
            }
            if (prevStep != null && prevStepUI != null) {
                switch (command) {
                    case 1: {
                        this.flashStep(prevMapPane, prevStepUI);
                        this.moveTokenAlongRoute(prevMapPane, nextMapPane, prevStep, nextStep);
                        this.flashStep(nextMapPane, nextStepUI);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.flashStep(prevMapPane, prevStepUI);
                        this.flashStep(nextMapPane, nextStepUI);
                    }
                }
            }
        }
    }

    protected void flashStep(VWSIMAnimatorWorkflowMapPane mapPane, IVWSIMAnimatorStepUI step) {
        if (mapPane == null || step == null) {
            return;
        }
        if (!this.m_workflowPane.isActiveMapPane(mapPane)) {
            return;
        }
        VWSIMAnimatorStepUI stepUI = step.getAnimatorStepUI();
        if (stepUI != null) {
            stepUI.flashWorkItem(true);
            int count = VWSIMAnimatorStepUI.getFlashCount();
            do {
                if (this.m_workflowPane.isActiveMapPane(mapPane)) {
                    mapPane.invalidRegion(stepUI);
                }
                if (!stepUI.isFlashingWorkItem()) break;
                this.m_eventCount = 0;
                --count;
                if (!this.m_workflowPane.isActiveMapPane(mapPane)) break;
                Thread.yield();
            } while (count > 0);
        }
        if (this.m_workflowPane.isActiveMapPane(mapPane)) {
            mapPane.invalidRegion(stepUI);
        }
    }

    protected void moveTokenAlongRoute(VWSIMAnimatorWorkflowMapPane prevMapPane, VWSIMAnimatorWorkflowMapPane nextMapPane, VWSIMAnimatorStep prevStep, VWSIMAnimatorStep nextStep) {
        if (prevMapPane != null && prevStep != null && nextMapPane != null && nextStep != null && this.m_workflowPane != null && this.m_workflowPane.isActiveMapPane(prevMapPane) && prevMapPane == nextMapPane) {
            Object obj = null;
            VWSIMAnimatorRoute route = null;
            Vector routes = prevStep.getNextRoutes();
            if (routes != null) {
                block0: for (int i = 0; i < routes.size(); ++i) {
                    VWSIMAnimatorRouteUI baseRouteUI;
                    obj = routes.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorRoute) || nextStep != (route = (VWSIMAnimatorRoute)obj).getNextStep() || (baseRouteUI = this.m_workflowPane.findRoute(prevStep.getWorkflow().getWorkClassId(), prevStep.getMapId(), route)) == null || !(baseRouteUI instanceof VWSIMAnimatorRouteUI)) continue;
                    VWSIMAnimatorRouteUI routeUI = baseRouteUI;
                    routeUI.moveWorkItem(true);
                    long delay = this.m_delayInMilliSeconds / (long)VWSIMAnimatorRouteUI.getMoveCount();
                    if (delay == 0L) {
                        delay = 1L;
                    }
                    int count = VWSIMAnimatorRouteUI.getMoveCount();
                    do {
                        routeUI.moveWorkIcon();
                        if (!routeUI.isMovingWorkItem()) break block0;
                        this.m_eventCount = 0;
                        Thread.yield();
                    } while (--count > 0);
                    break;
                }
            }
        }
    }

    public void setDelayTime(long miliSeconds) {
        this.m_delayInMilliSeconds = miliSeconds;
    }

    public long getDelayTime() {
        return this.m_delayInMilliSeconds;
    }

    protected IVWSIMAnimatorStepUI findStepUI(int workClassId, String mapId, int stepId) {
        if (mapId != null) {
            try {
                int id = Integer.parseInt(mapId);
                return this.findStepUI(workClassId, id, stepId);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected IVWSIMAnimatorStepUI findStepUI(int workClassId, int mapId, int stepId) {
        if (!this.m_bInitialized) {
            return null;
        }
        if (this.m_workflowPane != null) {
            return this.m_workflowPane.findStep(workClassId, mapId, stepId);
        }
        return null;
    }

    protected VWSIMAnimatorStep findStep(int workClassId, int mapId, int stepId) {
        IVWSIMAnimatorStepUI stepUI;
        if (!this.m_bInitialized) {
            return null;
        }
        if (this.m_workflowPane != null && (stepUI = this.findStepUI(workClassId, mapId, stepId)) != null) {
            return stepUI.getStepData();
        }
        return null;
    }

    protected VWBaseStepUI findBaseStepUI(int workClassId, int mapId, int stepId) {
        if (!this.m_bInitialized) {
            return null;
        }
        if (this.m_workflowPane != null) {
            return this.m_workflowPane.findBaseStep(workClassId, mapId, stepId);
        }
        return null;
    }

    public void addAnimationUpdateListener(IVWSIMAnimationUpdateListener l) {
        if (this.m_animationUpdateListeners != null && l != null) {
            this.m_animationUpdateListeners.add(l);
        }
    }

    public void removeAnimationUpdateListener(IVWSIMAnimationUpdateListener l) {
        if (this.m_animationUpdateListeners != null && l != null) {
            this.m_animationUpdateListeners.remove(l);
        }
    }

    public void notifyAnimationUpdateListener(VWSIMAnimationUpdateEvent e) {
        if (this.m_animationUpdateListeners != null) {
            Object obj = null;
            for (int i = 0; i < this.m_animationUpdateListeners.size(); ++i) {
                obj = this.m_animationUpdateListeners.elementAt(i);
                if (!(obj != null & obj instanceof IVWSIMAnimationUpdateListener)) continue;
                ((IVWSIMAnimationUpdateListener)obj).animationUpdate(e);
            }
        }
    }

    private void updateWorkflowStatistics() {
        try {
            if (this.m_lastEvent != null) {
                boolean bUpdate = true;
                Date eventTime = this.m_lastEvent.getTimeStamp();
                if (eventTime != null) {
                    // empty if block
                }
                if (bUpdate) {
                    IVWSIMStatistics statistics = this.m_lastEvent.getStatistics();
                    this.updateWorkflowStatistics(statistics);
                    this.notifyAnimationUpdateListener(new VWSIMAnimationUpdateEvent(this, this.m_lastEvent, 0));
                }
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
    }

    private void updateWorkflowStatistics(IVWSIMStatistics statistics) {
        VWSIMAnimatorScenario scenario;
        if (statistics != null && this.m_dataModel != null && (scenario = this.m_dataModel.getScenario()) != null) {
            IVWSIMWorkClassStats[] workClasses;
            scenario.setActiveCount(statistics.getAllActiveWorkflowCount());
            scenario.setLaunchedCount(statistics.getAllLaunchedWorkflowCount());
            scenario.setCompletedCount(statistics.getAllCompletedWorkflowCount());
            scenario.setOverdueCount(statistics.getAllOverdueWorkflowCount());
            scenario.setCost(statistics.getAllTotalCost());
            scenario.setAverageCost(statistics.getAllAverageCost());
            scenario.setMinCycleTime(statistics.getAllMinCycleTimeForCompletedWorkflow());
            scenario.setMaxCycleTime(statistics.getAllMaxCycleTimeForCompletedWorkflow());
            scenario.setAverageCycleTime((long)statistics.getAllAvgCycleTimeForCompletedWorkflow());
            IVWSIMQueueStats[] queues = statistics.getQueuesStats();
            IVWSIMQueueStats queue = null;
            VWSIMAnimatorQueue animatorQueue = null;
            if (queues != null) {
                for (int i = 0; i < queues.length; ++i) {
                    queue = queues[i];
                    if (queue == null || (animatorQueue = scenario.findQueue(queue.getName())) == null) continue;
                    animatorQueue.setActiveCount(queue.getActiveWorkItemCount());
                    animatorQueue.setCompletedCount(queue.getCompletedWorkItemCount());
                    animatorQueue.setOverdueCount(queue.getOverdueWorkItemCount());
                    animatorQueue.setCost(queue.getTotalCost());
                    animatorQueue.setAverageCost(queue.getAverageCost());
                }
            }
            IVWSIMUserStats[] users = statistics.getUsersStats();
            IVWSIMUserStats user = null;
            VWSIMAnimatorUser animatorUser = null;
            if (users != null) {
                for (int i = 0; i < users.length; ++i) {
                    user = users[i];
                    if (user == null) continue;
                    animatorUser = scenario.findUser(user.getName());
                    if (animatorUser == null) {
                        animatorUser = scenario.newUser(user.getName());
                    }
                    if (animatorUser == null) continue;
                    animatorUser.setAssignedCount(user.getAssignedWorkItemCount());
                    animatorUser.setActiveCount(user.getActiveWorkItemCount());
                    animatorUser.setCompletedCount(user.getCompletedWorkItemCount());
                    animatorUser.setOverdueCount(user.getOverdueWorkItemCount());
                    animatorUser.setCost(user.getTotalCost());
                    animatorUser.setAverageCost(user.getAverageCost());
                }
            }
            if ((workClasses = statistics.getWorkClassesStats()) != null && workClasses.length > 0) {
                IVWSIMWorkClassStats workClass = null;
                VWSIMAnimatorWorkflow workflow = null;
                for (int i = 0; i < workClasses.length; ++i) {
                    workClass = workClasses[i];
                    if (workClass == null || (workflow = scenario.getWorkflow(workClass.getWorkClassId())) == null) continue;
                    workflow.setActiveCount(workClass.getActiveWorkflowCount());
                    workflow.setLaunchedCount(workClass.getLaunchedWorkflowCount());
                    workflow.setCompletedCount(workClass.getCompletedWorkflowCount());
                    workflow.setOverdueCount(workClass.getOverdueWorkflowCount());
                    workflow.setCost(workClass.getTotalCost());
                    workflow.setAverageCost(workClass.getAverageCost());
                    workflow.setMinCycleTime(workClass.getMinCycleTimeForCompletedWorkflow());
                    workflow.setMaxCycleTime(workClass.getMaxCycleTimeForCompletedWorkflow());
                    workflow.setAverageCycleTime((long)workClass.getAvgCycleTimeForCompletedWorkflow());
                    IVWSIMMapStats[] maps = workClass.getMapsStats();
                    if (maps == null || maps.length <= 0) continue;
                    IVWSIMMapStats map = null;
                    VWSIMAnimatorMap animatorMap = null;
                    for (int j = 0; j < maps.length; ++j) {
                        IVWSIMStepStats[] steps;
                        map = maps[j];
                        if (map == null || (animatorMap = workflow.getMap(map.getMapId())) == null || (steps = map.getStepsStats()) == null || steps.length <= 0) continue;
                        VWSIMAnimatorWorkflowMapPane mapPane = this.m_workflowPane.getMapPane(workClass.getWorkClassId(), map.getMapId());
                        IVWSIMStepStats step = null;
                        VWSIMAnimatorStep animatorStep = null;
                        for (int k = 0; k < steps.length; ++k) {
                            IVWSIMAnimatorStepUI stepUI;
                            step = steps[k];
                            if (step == null) continue;
                            animatorStep = animatorMap.getStep(step.getStepId());
                            int activeCount = step.getActiveWorkItemCount();
                            int prevActiveCount = -1;
                            if (animatorStep != null) {
                                prevActiveCount = animatorStep.getActiveCount();
                                animatorStep.setActiveCount(activeCount);
                                animatorStep.setCompletedCount(step.getCompletedWorkItemCount());
                                animatorStep.setOverdueCount(step.getOverdueWorkItemCount());
                                animatorStep.setCost(step.getTotalCost());
                                animatorStep.setAverageCost(step.getAverageCost());
                                animatorStep.setMaxProcessingTime(step.getMaxProcessingTime());
                                animatorStep.setMinProcessingTime(step.getMinProcessingTime());
                                animatorStep.setAverageProcessingTime(step.getAvgProcessingTime());
                                animatorStep.setMaxCompletionTime(step.getMaxCycleTime());
                                animatorStep.setMinCompletionTime(step.getMinCycleTime());
                                animatorStep.setAverageCompletionTime(step.getAvgCycleTime());
                                animatorStep.setMaxWaitTime(step.getMaxWaitTime());
                                animatorStep.setMinWaitTime(step.getMinWaitTime());
                                animatorStep.setAverageWaitTime(step.getAvgWaitTime());
                            }
                            if (mapPane == null || (stepUI = this.findStepUI(workClass.getWorkClassId(), map.getMapId(), step.getStepId())) == null || !(stepUI instanceof VWBaseStepUI)) continue;
                            stepUI.getAnimatorStepUI().updateActiveItemCount();
                            mapPane.invalidRegion((VWBaseStepUI)((Object)stepUI));
                        }
                    }
                }
            }
        }
    }

    public void writeToFiles(String scenarioDefinitionFileName, String eventBufferFileName) {
        try {
            if (this.m_animationDP != null) {
                if (!this.isFinished()) {
                    IVWSIMEvent event = null;
                    while ((event = this.m_animationDP.getEvent()) == null || !event.finished()) {
                    }
                    this.setFinished(true);
                }
                this.m_animationDP.writeToFiles(scenarioDefinitionFileName, eventBufferFileName);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, ex.getLocalizedMessage());
        }
    }

    public void done() {
        this.m_bDone = true;
    }

    public void releaseResources() {
        this.m_bDone = true;
        if (this.m_animationDP != null) {
            try {
                this.m_animationDP.stopRetrieval();
            }
            catch (VWException ex) {
                VWDebug.logException(ex, ex.getLocalizedMessage());
            }
            this.m_animationDP.releaseResources();
        }
        this.m_semaphore = null;
        this.m_simulation = null;
        this.m_animationDP = null;
        this.m_dataModel = null;
        this.m_workflowPane = null;
        if (this.m_workflowMaps != null) {
            this.m_workflowMaps.removeAllElements();
            this.m_workflowMaps = null;
        }
        this.m_finishedObject = null;
        this.m_lastEvent = null;
        this.m_lastEventTime = null;
        this.m_lastPlayedEventTime = null;
        this.m_lastEventSemaphore = null;
        this.m_animationTime = null;
        this.m_animationTimeUpdateSemaphore = null;
        this.m_simulationBeginTime = null;
        this.m_simulationEndTime = null;
        this.m_simulationDuration = null;
        if (this.m_animationUpdateListeners != null) {
            this.m_animationUpdateListeners.removeAllElements();
            this.m_animationUpdateListeners = null;
        }
    }

    private boolean ignoreEvent(IVWSIMEvent event) {
        if (event != null) {
            if (event.finished()) {
                return false;
            }
            Date eventTime = event.getTimeStamp();
            return eventTime != null && this.m_lastPlayedEventTime != null && eventTime.getTime() == this.m_lastPlayedEventTime.getTime();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnimationTime(Date animationTime) {
        Object object = this.m_animationTimeUpdateSemaphore;
        synchronized (object) {
            this.m_animationTime = animationTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getAnimationTime() {
        Object object = this.m_animationTimeUpdateSemaphore;
        synchronized (object) {
            if (this.m_playMode == 2 && this.m_animationStartTime != -1L && this.m_realStartTime != -1L) {
                long time = (new Date().getTime() - this.m_realStartTime) * (long)this.m_timeRatio + this.m_animationStartTime;
                if (this.m_lastEventTime != null && time > this.m_lastEventTime.getTime()) {
                    this.m_realStartTime = -1L;
                    this.m_animationStartTime = -1L;
                    this.m_realTimeDuration = 0L;
                    this.m_animationTimeDuration = 0L;
                    return this.m_lastEventTime;
                }
                return new Date(time);
            }
            return this.m_animationTime;
        }
    }

    public Date getSimulationStartTime() {
        return this.m_simulationBeginTime;
    }

    public Date getSimulationEndTime() {
        return this.m_simulationEndTime;
    }

    public VWDuration getSimulationDuration() {
        if (this.m_simulationDuration == null && this.m_simulationBeginTime != null && this.m_simulationEndTime != null) {
            this.m_simulationDuration = new VWDuration((this.m_simulationEndTime.getTime() - this.m_simulationBeginTime.getTime()) / 1000L);
        }
        return this.m_simulationDuration;
    }

    public VWDuration getPlaybackDuration() {
        return new VWDuration(this.m_playbackDuration / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVWSIMEvent getLastEvent() {
        Object object = this.m_lastEventSemaphore;
        synchronized (object) {
            return this.m_lastEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastEventTime() {
        Object object = this.m_lastEventSemaphore;
        synchronized (object) {
            return this.m_lastEventTime;
        }
    }

    private void notifyTimeAndStatUpdates() {
        IVWSIMEvent event = this.getLastEvent();
        try {
            IVWSIMStatistics statistics;
            if (event != null && (statistics = event.getStatistics()) != null && this.m_bPlayAnimation && this.m_bUpdateStats) {
                this.updateWorkflowStatistics(statistics);
                this.m_bUpdateStats = false;
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, ex.getLocalizedMessage());
        }
        this.notifyAnimationUpdateListener(new VWSIMAnimationUpdateEvent(this, event, 0));
    }

    public int getPlaybackRate() {
        this.m_playbackRate = this.m_timeRatio / 60;
        return this.m_playbackRate;
    }

    public void setPlaybackRate(int playbackRate) {
        if (this.getPlayMode() != 2) {
            this.m_playbackRate = playbackRate;
            this.m_timeRatio = this.m_playbackRate * 60;
        }
    }
}

